// backend/server.js
require('dotenv').config();
const express = require('express');
const mongoose = require('mongoose');
const cors = require('cors');
const { startScheduler } = require('./services/notificationScheduler');

const app = express();
app.use(cors());
app.use(express.json()); // To parse JSON bodies

const PORT = process.env.PORT || 5000;

// Connect to MongoDB
mongoose.connect(process.env.MONGO_URI)
  .then(() => {
    console.log('DB Connected...');
    // Start the notification scheduler after DB connection
    startScheduler();
  })
  .catch(err => console.log(err));

// Simple test route
app.get('/', (req, res) => {
  res.send('API is running...');
});

// Define Routes
app.use('/api/auth', require('./routes/authRoutes'));
app.use('/api/user', require('./routes/userRoutes'));
// Menu routes
app.use('/api/menu', require('./routes/menuRoutes'));
// Orders routes
app.use('/api/orders', require('./routes/orderRoutes'));
// Coupons routes
app.use('/api/coupons', require('./routes/couponRoutes'));
// Payments routes (Razorpay)
app.use('/api/payments', require('./routes/paymentRoutes'));

// Admin routes (protected by ADMIN_SECRET header)
app.use('/api/admin', require('./routes/adminRoutes'));
app.use('/api/admin/auth', require('./routes/adminAuthRoutes'));

// We will add our auth and menu routes here later

// Health endpoint to be used by render uptime
app.get('/api/health', (req, res) => res.json({ ok: true }));

// JSON 404 fallback to avoid HTML error pages
app.use((req, res) => {
  res.status(404).json({ message: 'Not Found' });
});

app.listen(PORT, () => console.log(`Server running on port ${PORT}`));